# SPDX-FileCopyrightText: 2021 Mark Komus
# SPDX-License-Identifier: MIT

"""
LED glasses mappings
"""
# Maps to link IS31FL3741 LEDs to pixels

# Full LED glasses 18 x 5 matrix
glassesmatrix_ledmap = (
    65535,
    65535,
    65535,  # (0,0) (clipped, corner)
    10,
    8,
    9,  # (0,1) / right ring pixel 20
    13,
    11,
    12,  # (0,2) / 19
    16,
    14,
    15,  # (0,3) / 18
    4,
    2,
    3,  # (0,4) / 17
    217,
    215,
    216,  # (1,0) / right ring pixel #21
    220,
    218,
    219,  # (1,1)
    223,
    221,
    222,  # (1,2)
    226,
    224,
    225,  # (1,3)
    214,
    212,
    213,  # (1,4)
    187,
    185,
    186,  # (2,0)
    190,
    188,
    189,  # (2,1)
    193,
    191,
    192,  # (2,2)
    196,
    194,
    195,  # (2,3)
    184,
    182,
    183,  # (2,4)
    37,
    35,
    36,  # (3,0)
    40,
    38,
    39,  # (3,1)
    43,
    41,
    42,  # (3,2)
    46,
    44,
    45,  # (3,3)
    34,
    32,
    33,  # (3,4)
    67,
    65,
    66,  # (4,0)
    70,
    68,
    69,  # (4,1)
    73,
    71,
    72,  # (4,2)
    76,
    74,
    75,  # (4,3)
    64,
    62,
    63,  # (4,4)
    97,
    95,
    96,  # (5,0)
    100,
    98,
    99,  # (5,1)
    103,
    101,
    102,  # (5,2)
    106,
    104,
    105,  # (5,3)
    94,
    92,
    93,  # (5,4)
    127,
    125,
    126,  # (6,0) / right ring pixel 3
    130,
    128,
    129,  # (6,1)
    133,
    131,
    132,  # (6,2)
    136,
    134,
    135,  # (6,3)
    124,
    122,
    123,  # (6,4)
    157,
    155,
    156,  # (7,0)
    160,
    158,
    159,  # (7,1)
    163,
    161,
    162,  # (7,2) / right ring pixel 5
    166,
    164,
    165,  # (7,3) / 6
    244,
    242,
    243,  # (7,4) / 7
    247,
    245,
    246,  # (8,0)
    250,
    248,
    249,  # (8,1)
    253,
    251,
    252,  # (8,2)
    256,
    254,
    255,  # (8,3)
    65535,
    65535,
    65535,  # (8,4) (clipped, nose bridge)
    345,
    347,
    346,  # (9,0)
    342,
    344,
    343,  # (9,1)
    267,
    269,
    268,  # (9,2)
    263,
    265,
    264,  # (9,3)
    65535,
    65535,
    65535,  # (9,4) (clipped, nose bridge)
    336,
    338,
    337,  # (10,0)
    333,
    335,
    334,  # (10,1)
    237,
    239,
    238,  # (10,2) / left ring pixel 19
    233,
    235,
    234,  # (10,3) / 18
    348,
    262,
    349,  # (10,4) / 17
    327,
    329,
    328,  # (11,0) / left ring pixel 21
    324,
    326,
    325,  # (11,1)
    207,
    209,
    208,  # (11,2)
    203,
    205,
    204,  # (11,3)
    330,
    202,
    331,  # (11,4)
    318,
    320,
    319,  # (12,0)
    315,
    317,
    316,  # (12,1)
    177,
    179,
    178,  # (12,2)
    173,
    175,
    174,  # (12,3)
    321,
    172,
    322,  # (12,4)
    309,
    311,
    310,  # (13,0)
    306,
    308,
    307,  # (13,1)
    147,
    149,
    148,  # (13,2)
    143,
    145,
    144,  # (13,3)
    312,
    142,
    313,  # (13,4)
    300,
    302,
    301,  # (14,0)
    297,
    299,
    298,  # (14,1)
    117,
    119,
    118,  # (14,2)
    113,
    115,
    114,  # (14,3)
    303,
    112,
    304,  # (14,4)
    291,
    293,
    292,  # (15,0)
    288,
    290,
    289,  # (15,1)
    87,
    89,
    88,  # (15,2)
    83,
    85,
    84,  # (15,3)
    294,
    82,
    295,  # (15,4)
    282,
    284,
    283,  # (16,0) / left ring pixel 3
    279,
    281,
    280,  # (16,1)
    57,
    59,
    58,  # (16,2)
    53,
    55,
    54,  # (16,3)
    285,
    52,
    286,  # (16,4)
    65535,
    65535,
    65535,  # (17,0) (clipped, corner)
    270,
    272,
    271,  # (17,1) / left ring pixel 4
    27,
    29,
    28,  # (17,2) / 5
    23,
    25,
    24,  # (17,3) / 6
    276,
    22,
    277,  # (17,4) / 7
)

# LED glasses 18 x 5 matrix but excluding LEDs shared with the eye rings
glassesmatrix_ledmap_no_ring = (
    65535,
    65535,
    65535,  # (0,0) (clipped, corner)
    65535,
    65535,
    65535,  # (0,1) / right ring pixel 20
    65535,
    65535,
    65535,  # (0,2) / 19
    65535,
    65535,
    65535,  # (0,3) / 18
    65535,
    65535,
    65535,  # (0,4) / 17
    65535,
    65535,
    65535,  # (1,0) / right ring pixel #21
    220,
    218,
    219,  # (1,1)
    223,
    221,
    222,  # (1,2)
    226,
    224,
    225,  # (1,3)
    214,
    212,
    213,  # (1,4)
    187,
    185,
    186,  # (2,0)
    190,
    188,
    189,  # (2,1)
    193,
    191,
    192,  # (2,2)
    196,
    194,
    195,  # (2,3)
    184,
    182,
    183,  # (2,4)
    37,
    35,
    36,  # (3,0)
    40,
    38,
    39,  # (3,1)
    43,
    41,
    42,  # (3,2)
    46,
    44,
    45,  # (3,3)
    34,
    32,
    33,  # (3,4)
    67,
    65,
    66,  # (4,0)
    70,
    68,
    69,  # (4,1)
    73,
    71,
    72,  # (4,2)
    76,
    74,
    75,  # (4,3)
    64,
    62,
    63,  # (4,4)
    97,
    95,
    96,  # (5,0)
    100,
    98,
    99,  # (5,1)
    103,
    101,
    102,  # (5,2)
    106,
    104,
    105,  # (5,3)
    94,
    92,
    93,  # (5,4)
    127,
    125,
    126,  # (6,0) / right ring pixel 3
    130,
    128,
    129,  # (6,1)
    133,
    131,
    132,  # (6,2)
    136,
    134,
    135,  # (6,3)
    124,
    122,
    123,  # (6,4)
    157,
    155,
    156,  # (7,0)
    160,
    158,
    159,  # (7,1)
    163,
    161,
    162,  # (7,2) / right ring pixel 5
    166,
    164,
    165,  # (7,3) / 6
    244,
    242,
    243,  # (7,4) / 7
    247,
    245,
    246,  # (8,0)
    250,
    248,
    249,  # (8,1)
    253,
    251,
    252,  # (8,2)
    256,
    254,
    255,  # (8,3)
    65535,
    65535,
    65535,  # (8,4) (clipped, nose bridge)
    345,
    347,
    346,  # (9,0)
    342,
    344,
    343,  # (9,1)
    267,
    269,
    268,  # (9,2)
    263,
    265,
    264,  # (9,3)
    65535,
    65535,
    65535,  # (9,4) (clipped, nose bridge)
    336,
    338,
    337,  # (10,0)
    333,
    335,
    334,  # (10,1)
    237,
    239,
    238,  # (10,2) / left ring pixel 19
    233,
    235,
    234,  # (10,3) / 18
    348,
    262,
    349,  # (10,4) / 17
    327,
    329,
    328,  # (11,0) / left ring pixel 21
    324,
    326,
    325,  # (11,1)
    207,
    209,
    208,  # (11,2)
    203,
    205,
    204,  # (11,3)
    330,
    202,
    331,  # (11,4)
    318,
    320,
    319,  # (12,0)
    315,
    317,
    316,  # (12,1)
    177,
    179,
    178,  # (12,2)
    173,
    175,
    174,  # (12,3)
    321,
    172,
    322,  # (12,4)
    309,
    311,
    310,  # (13,0)
    306,
    308,
    307,  # (13,1)
    147,
    149,
    148,  # (13,2)
    143,
    145,
    144,  # (13,3)
    312,
    142,
    313,  # (13,4)
    300,
    302,
    301,  # (14,0)
    297,
    299,
    298,  # (14,1)
    117,
    119,
    118,  # (14,2)
    113,
    115,
    114,  # (14,3)
    303,
    112,
    304,  # (14,4)
    291,
    293,
    292,  # (15,0)
    288,
    290,
    289,  # (15,1)
    87,
    89,
    88,  # (15,2)
    83,
    85,
    84,  # (15,3)
    294,
    82,
    295,  # (15,4)
    65535,
    65535,
    65535,  # (16,0) / left ring pixel 3
    279,
    281,
    280,  # (16,1)
    57,
    59,
    58,  # (16,2)
    53,
    55,
    54,  # (16,3)
    285,
    52,
    286,  # (16,4)
    65535,
    65535,
    65535,  # (17,0) (clipped, corner)
    65535,
    65535,
    65535,  # (17,1) / left ring pixel 4
    65535,
    65535,
    65535,  # (17,2) / 5
    65535,
    65535,
    65535,  # (17,3) / 6
    65535,
    65535,
    65535,  # (17,4) / 7
)

# Left LED glasses eye ring
left_ring_map = (
    341,
    210,
    211,  # 0
    332,
    180,
    181,  # 1
    323,
    150,
    151,  # 2
    127,
    125,
    126,  # 3
    154,
    152,
    153,  # 4
    163,
    161,
    162,  # 5
    166,
    164,
    165,  # 6
    244,
    242,
    243,  # 7
    259,
    257,
    258,  # 8
    169,
    167,
    168,  # 9
    139,
    137,
    138,  # 10
    109,
    107,
    108,  # 11
    79,
    77,
    78,  # 12
    49,
    47,
    48,  # 13
    199,
    197,
    198,  # 14
    229,
    227,
    228,  # 15
    19,
    17,
    18,  # 16
    4,
    2,
    3,  # 17
    16,
    14,
    15,  # 18
    13,
    11,
    12,  # 19
    10,
    8,
    9,  # 20
    217,
    215,
    216,  # 21
    7,
    5,
    6,  # 22
    350,
    240,
    241,  # 23
)

# Left LED glasses eye ring excluding inner LEDs shared with the 18 x 5 matrix
left_ring_map_no_inner = (
    341,
    210,
    211,  # 0
    332,
    180,
    181,  # 1
    323,
    150,
    151,  # 2
    65535,
    65535,
    65535,  # 3
    65535,
    65535,
    65535,  # 4
    65535,
    65535,
    65535,  # 5
    65535,
    65535,
    65535,  # 6
    65535,
    65535,
    65535,  # 7
    259,
    257,
    258,  # 8
    169,
    167,
    168,  # 9
    139,
    137,
    138,  # 10
    109,
    107,
    108,  # 11
    79,
    77,
    78,  # 12
    49,
    47,
    48,  # 13
    199,
    197,
    198,  # 14
    229,
    227,
    228,  # 15
    19,
    17,
    18,  # 16
    4,
    2,
    3,  # 17
    16,
    14,
    15,  # 18
    13,
    11,
    12,  # 19
    10,
    8,
    9,  # 20
    217,
    215,
    216,  # 21
    7,
    5,
    6,  # 22
    350,
    240,
    241,  # 23
)

# Right LED glasses eye ring
right_ring_map = (
    287,
    30,
    31,  # 0
    278,
    0,
    1,  # 1
    273,
    275,
    274,  # 2
    282,
    284,
    283,  # 3
    270,
    272,
    271,  # 4
    27,
    29,
    28,  # 5
    23,
    25,
    24,  # 6
    276,
    22,
    277,  # 7
    20,
    26,
    21,  # 8
    50,
    56,
    51,  # 9
    80,
    86,
    81,  # 10
    110,
    116,
    111,  # 11
    140,
    146,
    141,  # 12
    170,
    176,
    171,  # 13
    200,
    206,
    201,  # 14
    230,
    236,
    231,  # 15
    260,
    266,
    261,  # 16
    348,
    262,
    349,  # 17
    233,
    235,
    234,  # 18
    237,
    239,
    238,  # 19
    339,
    232,
    340,  # 20
    327,
    329,
    328,  # 21
    305,
    90,
    91,  # 22
    296,
    60,
    61,  # 23
)

# Right LED glasses eye ring excluding inner LEDs shared with the 18 x 5 matrix
right_ring_map_no_inner = (
    287,
    30,
    31,  # 0
    278,
    0,
    1,  # 1
    273,
    275,
    274,  # 2
    282,
    284,
    283,  # 3
    270,
    272,
    271,  # 4
    27,
    29,
    28,  # 5
    23,
    25,
    24,  # 6
    276,
    22,
    277,  # 7
    20,
    26,
    21,  # 8
    50,
    56,
    51,  # 9
    80,
    86,
    81,  # 10
    110,
    116,
    111,  # 11
    140,
    146,
    141,  # 12
    170,
    176,
    171,  # 13
    200,
    206,
    201,  # 14
    230,
    236,
    231,  # 15
    260,
    266,
    261,  # 16
    65535,
    65535,
    65535,  # 17
    65535,
    65535,
    65535,  # 18
    65535,
    65535,
    65535,  # 19
    65535,
    65535,
    65535,  # 20
    65535,
    65535,
    65535,  # 21
    305,
    90,
    91,  # 22
    296,
    60,
    61,  # 23
)
